
function AMZEditor(editorx) {
    //amz_clog_info("editorxy  " + editorx)
    //this.editor_js = editorx //editor_js
    this.editor = $(editorx) //editor_jquery
    //amz_clog_info("editorx  " + this.editor)
    this.currentSelection = null;
    var me = this
    var inizitialize_bag = {}

    this.initializex = function (obj_base64) {
        try {
            var bag = composer_decode(obj_base64);
            amz_clog_info("initializex bag " + bag);
//            amz_clog_info("focus " + bag.focus);
            this.inizitialize_bag = bag

            if(bag.focus > 0){
                editorx.focus()
            }
            
            //this.apply_font()

        } catch (ex) {
            amz_clog_err("initializex " + ex);
        }
    }
    
    //amz_clog_info("editor started")
    this.xcommand = function (obj_base64) {
        try {
            var commandDictionary = composer_decode(obj_base64);
            unlistenOnSelectionChange();                //stoppo listener
            var res = me.command(commandDictionary);
            listenOnSelectionChange();                  //rialzo listener
            selectionchanged();
            me.notify_height_changed();

            //            setTimeout(function(){
            //                amz_clog_info("setTimeout " + $(document).height());
            //                this.notify_height_changed()
            //            }, 1000);
            return res;
        } catch (ex) {
            amz_clog_err("amz_command " + ex);
        }
    }
    
    this.command = function (commandDictionary) {
        try{
            var res = null
            var command = commandDictionary.command;
            amz_clog_info("js_command " + command)
            
            if (command === 'backup_range') {
                this.backuprange();
            } else if (command === 'insert_image') {
                this.insertImage(commandDictionary.src, commandDictionary.alt, commandDictionary.class_name, commandDictionary.width, commandDictionary.height);
            } else if (command === 'change_signature') {
                this.changeSignature(commandDictionary.html)
            } else if (command === 'insert_html') {
                this.insertHTML(commandDictionary.html)
            } else if (command === 'increaseFontSize') {
                var sel_attr = this.selection_attributes()
                var fs       = parseInt(sel_attr.fontSize)
                document.execCommand("fontSize", false, fs+1);
            } else if (command === 'decreaseFontSize') {
                var sel_attr = this.selection_attributes()
                var fs       = parseInt(sel_attr.fontSize)
                document.execCommand("fontSize", false, fs-1);
            } else if (command === 'style_with_css') {
                
                this.apply_font_internal(commandDictionary)
                
//                var sel     = this.selection();
//                var range   = sel.getRangeAt(0);
//                document.execCommand("styleWithCSS", null, true);
//                if(isRealValue(commandDictionary.font)){
//                    document.execCommand("fontname",  false, commandDictionary.font);
//                }
//                if(isRealValue(commandDictionary.size)){
//                    var sel     = this.selection();
//                    var range   = sel.getRangeAt(0);
////                    var start   = range.startContainer
////                    amz_clog_info("start " + start)
////                    var jstart  = $(start)
////                    var fs = this.get_style(jstart, "font-size")
////                    amz_clog_info("fs " + fs.style)
////                    if(isRealValue(fs.style) && isRealValue(fs.node)){
////                        fs.node.css("font-size",commandDictionary.size+"px")
////                    }else{
//                    var newNode = document.createElement("span");
//                    $(newNode).css("font-size", commandDictionary.size+"px")
//                    range.surroundContents(newNode);
////                    }
//                    //document.execCommand("fontsize",  false, commandDictionary.size+'px');
//                }
//                if(isRealValue(commandDictionary.color)){
//                    //amz_clog_info("color " + commandDictionary.color)
//                    document.execCommand("forecolor", false, commandDictionary.color);//'rgba(0,0,0,0.5)');
//                }
//                document.execCommand("styleWithCSS", null, false);

            } else if (command === 'insert_link') {
                res = this.insertLink(commandDictionary.link);
            } else {
                //amz_clog_info("generic command " + command)
                document.execCommand(command, false, null);
            }
        }catch(ex){
            amz_clog_err("command " + ex)
        }
        return res
    }
    
    this.changeSignature = function(html) {
        try{
            //amz_clog_info("changeSignature " + html)
            if(isRealValue(html) == false){
                return
            }
            //this.restorerange();
            
            var sign = $("body").find(".gmail_signature").first()
            /*
            amz_clog_info("sign1 " + sign)
            amz_clog_info("sign2 " + sign.nodeName)
            amz_clog_info("sign3 " + $(sign))
            amz_clog_info("sign4 " + $(sign).html())
            */
            $(sign).replaceWith(html)
            
        }catch(ex){
            amz_clog_err("changeSignature " + ex)
        }

    }
    
    this.insertLink = function(link) {
        try{
            //amz_clog_info("insertLink1 [ " + link + " ] ")
            if(isRealValue(link) == false){
                return
            }
            this.restorerange();
            
            //SELECTION
            var sel     = this.selection();
            var range   = sel.getRangeAt(0);
            //amz_clog_info("range [ " + range + " ] ")
            var start   = range.startContainer;
            //amz_clog_info("start [ " + start + " ] ")
            var end   = range.endContainer;
            //amz_clog_info("end    [ " + end    + " ] ")
            
            var anchorHref = $(start).closest('a')
            if (anchorHref.length > 0){ //se sono dentro un href
                $(anchorHref).attr("href", link);
                return
            }

            
            //amz_clog_info("insertLink2 [ " + link + " ] ")
            var newNode = document.createElement("a");
            $(newNode).attr("href", link);

            
            //amz_clog_info("insertLink3 [ " + link + " ] ")
            if(start.nodeType === 3){ //TEXT
                $(newNode).text($(start).text());
                $(start).replaceWith($(newNode))
                return
            }
            
            //  var frag = range.extractContents();
            //  amz_clog_info("frag " + frag)
            //  var jfrag = $(frag)
            //  amz_clog_info("jfrag  " + jfrag)
            //  amz_clog_info("jfrag  " + jfrag.children().length)
            //  amz_clog_info("jfrag  " + jfrag.children()[0])
            
            var childrens =  $(start).children("img")
            if(childrens.length > 0){
                var jimage = childrens[0]
                //amz_clog_info("jimage0 " + jimage)
                if (isRealValue(jimage) && jimage.nodeName.toLowerCase() === "img"){
                    range.surroundContents(newNode);
                    return
                }
            }

            if(start.nodeName.toLowerCase() === "img"){ //IMG
                $(newNode).html($(start).html());
                $(start).replaceWith($(newNode))
                return
            }
            
            //amz_clog_info("insertLink4 [ " + link + " ] ")
            if (this.selection_text().length == 0 && start.nodeName.toLowerCase() != "img"){ //link ex novo
                $(newNode).text('Link');
                range.insertNode(newNode);
                return
            }

            //amz_clog_info("insertLink5 [ " + link + " ] ")
//            var go_on = false
//            if (start.nodeType === 3 && end.nodeType === 3)  {
//                go_on = true
//            } else if (start.nodeName.toLowerCase() === "img" && end.nodeName.toLowerCase() === "img") {
//                go_on = true
//            }
//            if (go_on == false) {
//                //amz_clog_info("cannot execute action")
//                return {error: "cannot execute action"}
//            }
            range.surroundContents(newNode);
            
        }catch(ex){
            amz_clog_err("insertLink " + ex)
        }
    }
    
    this.insertImage = function(src, alt, class_name, width, height) {
        try{
            this.restorerange();
            var html = '<img class = "' + class_name + '" src="' + src + '" alt="' + alt + '"';
            if (width > 0) {
                html += ' width  = ' + width + 'px ';
            }
            if (height > 0) {
                html += ' height = ' + height + 'px ';
            }
            html += '/>';
            this.insertHTML(html);
        }catch(ex){
            amz_clog_err("insertImage " + ex)
        }
    }
    
    this.insertHTML = function (html) {
        //amz_clog_info("insertHTML " + html)
        document.execCommand('insertHTML', false, html);
        
    }
    
    this.backuprange = function () {
        try{
            //            amz_clog_info("backuprange " + window)
            var selection = window.getSelection();
            //            amz_clog_info("selection " + selection)
            //            amz_clog_info("selection rangeCount " + selection.rangeCount)
            var range
            if(selection.rangeCount == 0){
                range = document.createRange();
                range.setStart(document.body, 0);
                range.setEnd(document.body, 0);
            }else{
                range = selection.getRangeAt(0);
            }
            this.currentSelection = {
                "startContainer": range.startContainer,
                "startOffset": range.startOffset,
                "endContainer": range.endContainer,
                "endOffset": range.endOffset
            };
        }catch(ex){
            amz_clog_err("backuprange " + ex)
        }
    }
    
    this.restorerange = function () {
        try{
            if (!this.currentSelection) {
                //amz_clog_info("null range")
                this.backuprange()
                //return
            }
            var selection = window.getSelection();
            selection.removeAllRanges();
            var range = document.createRange();
            //amz_clog_info("this.currentSelection.startContainer " + this.currentSelection.startContainer)
            range.setStart(this.currentSelection.startContainer, this.currentSelection.startOffset);
            range.setEnd(this.currentSelection.endContainer, this.currentSelection.endOffset);
            selection.addRange(range);
        }catch(ex){
            amz_clog_err("restorerange " + ex)
        }
    }
    
    this.notify_height_changed = function() {
        try{
            //            amz_clog_info("notify_height_changed " + this.editor)
            //            amz_clog_info("notify_height_changed " + this.editor.height())
            amz_csend_msg({composer_height_changed: this.editor.height()});
            /*
            try{
                amz_csend_msg({caret_position: this.getCaretYPosition()});
            }catch(ex){
                amz_clog_err("getCaretYPosition " + ex)
            }
            */
        }catch(ex){
            amz_clog_err("notify_height_changed " + ex)
        }
    }
    
    this.html = function() {
        return this.editor.html()
    }
    
    this.getCaretYPosition = function() {
        var sel = window.getSelection();
        // Next line is commented to prevent deselecting selection. It looks like work but if there are any issues will appear then uconmment it as well as code above.
        //sel.collapseToStart();
        var range = sel.getRangeAt(0);
        var span = document.createElement('span');// something happening here preventing selection of elements
        range.collapse(false);
        range.insertNode(span);
        
        var f =  span.getBoundingClientRect()
        //        amz_clog_info("y " + f.y)
        //        amz_clog_info("height " + f.height)
        var topPosition = f.y + f.height //  span.offsetTop;
        span.parentNode.removeChild(span);
        return topPosition;
    }
    
    //SELECTION
    function selectionchanged() {
        try{
            //amz_clog_info("selectionchanged0")
            var attributes     = me.selection_attributes();
            //amz_clog_info("selectionchanged1")
            attributes.text    = me.selection_text();
            //amz_clog_info("selectionchanged2")
            amz_csend_msg({composer_selection_changed: attributes});
            //amz_clog_info("selectionchanged3")
        } catch(ex){
            amz_clog_err("selectionchanged " + ex)
        }
    }
    
    function listenOnSelectionChange() {
        document.addEventListener("selectionchange",  selectionchanged, false);
    }
    
    function unlistenOnSelectionChange() {
        document.removeEventListener("selectionchange", selectionchanged, false);
    }
    listenOnSelectionChange()
    
    //document.addEventListener("selectionchange",  selectionchanged, false);
    this.selection_attributes = function() {
        try{
            var sel     = this.selection();
            var range   = sel.getRangeAt(0);
            var start   = range.startContainer;
            var jstart  = $(start);

            //amz_clog_info("start " + start)

            //https://rniwa.com/2010-11-06/improvements-in-querycommandstate-and-querycommandvalue/
            var isBold          = document.queryCommandState("Bold");
            var isItalic        = document.queryCommandState("Italic");
            var isUnderlined    = document.queryCommandState("Underline");
            var isSubscript     = document.queryCommandState("Subscript");
            var isSuperscript   = document.queryCommandState("Superscript");
            var isStrikethrough = document.queryCommandState("Strikethrough");
            
            var isIndent        = document.queryCommandState("Indent");
            var isOutdent       = document.queryCommandState("Outdent");

            var isJustifycenter = document.queryCommandState("Justifycenter");
            var isJustifyright  = document.queryCommandState("Justifyright");
            var isJustifyleft   = document.queryCommandState("Justifyleft");
            var isJustifyfull   = document.queryCommandState("Justifyfull");
            
            var fontSize        = document.queryCommandValue("fontSize");
            var isFormatBlock   = document.queryCommandValue("formatBlock");
            var isFontName      = document.queryCommandValue("fontname");
            if (isRealValue(isFontName)) {
                isFontName = replaceAll(isFontName,'"','') //"avenir next"
            }
            var isForeColor     = document.queryCommandValue("forecolor");
            
            //FONTSIZE
            var fontSizePx       = -1
            var fs = this.get_style(jstart, "font-size").style
            if (isRealValue(fs)) {
                try{
                    if(fs.endsWith("px")){
                        fs = fs.substring(0, fs.length-2);
                    }
                    fs = parseInt(fs);
                    fontSizePx = fs;
                } catch(ex){
                    amz_clog_err("selectionAttributes font-size" + ex)
                }
            }
            
            var anchorHref = jstart.closest('a').attr("href")

            return {
                'bold'            : isBold,          //.toString(),
                'italic'          : isItalic,        //.toString(),
                'underline'       : isUnderlined,    //.toString(),
                
                'subscript'       : isSubscript,     //.toString(),
                'superscript'     : isSuperscript,   //.toString(),
                'strikethrough'   : isStrikethrough, //.toString(),
                
                'indent'          : isIndent,        //.toString(),
                'outdent'         : isOutdent,       //.toString(),

                'justifyCenter'   : isJustifycenter, //.toString(),
                'justifyRight'    : isJustifyright,  //.toString(),
                'justifyLeft'     : isJustifyleft,   //.toString(),
                'justifyFull'     : isJustifyfull,   //.toString(),
                
                'fontSize'        : fontSize,        //.toString(),
                'fontName'        : isFontName,      //.toString(),
                'foreColor'       : isForeColor,     //.toString(),
                'formatBlock'     : isFormatBlock,   //.toString(),

                'fontSizePx'      : fontSizePx,      //.toString(),
                'anchorHref'      : anchorHref,     //.toString(),

                //'stylewithcss'    : styleWithCss,   //.toString(),

                //'showQuote'       : isBlockQuote.toString()
                
            };
        }
        catch(ex){
            amz_clog_err("selectionAttributes " + ex)
        }
        return {}
    }
    
    this.get_style = function(jnode, style){
        var ret = null
        try{
            //amz_clog_info("get_style1 " + style + " " + jnode[0].nodeType)
            //https://developer.mozilla.org/en-US/docs/Web/API/Node/nodeType
            if (jnode[0].nodeType == 1) {
                //amz_clog_info("jnode.nodeType " + jnode[0].nodeType)
                var css = jnode.css(style)
                if (isRealValue(style)){ return {node: jnode, style: css} }
            }
            //amz_clog_info("start3 " + jnode[0].nodeName)
            jnode.parents().each(function(){
                var css = $(this).css(style)
                                 //amz_clog_info("startx " + $(this)[0].nodeName)
                                 //amz_clog_info("startx " + css)
                if (isRealValue(style)) {
                    ret = {node: $(this), style: css}
                    return false
                }
            })

        }catch(ex){
            amz_clog_err("get_style " + ex)
        }
        //amz_clog_info("start4 " + ret)
        return ret
    }
    
    this.selection = function() {
        var sel;
        try{
            if (window.getSelection) {
                sel = window.getSelection();
            } else if (document.selection && document.selection.type != "Control") {
                sel = document.selection.createRange();
            }
        }catch(ex){
            amz_clog_err("selection " + ex)
        }
        return sel;
    }

    this.selection_range = function () {
        var range
        var sel     = this.selection();
        if(sel.rangeCount == 0){
            range = document.createRange();
            range.setStart(document.body, 0);
            range.setEnd(document.body, 0);
        }else{
            range = sel.getRangeAt(0);
        }
        return range
    }
    
    this.selection_text = function() {
        var text = "";
        try{
            if (window.getSelection) {
                text = window.getSelection().toString();
            } else if (document.selection && document.selection.type != "Control") {
                text = document.selection.createRange().text;
            }
        }catch(ex){
            amz_clog_err("selection_text " + ex)
        }
        return text;
    }
    
    /*
  //https://stackoverflow.com/questions/37471440/js-surroundcontents-only-retains-highlight-on-text-about-20-of-the-highlight
    this.surroundRangeWithSpan function(range) {
        var span = document.createElement('span');
        
        // The text is within the same node (no other html elements inside of it)
        if (range.startContainer.isEqualNode(range.endContainer) && range.startContainer.childNodes.length == 0) {
            // Here you customise your <span> element
            customSurroundContents(range, span);
        } else {
            // Here you have to break the selection down
        }
        return span;
    }
    
     this.customSurroundContents = function(range, span) {
        var node = range.commonAncestorContainer;
        var startNode = node.splitText(range.startOffset);
        var ret = startNode.splitText(range.toString().length);
        span.textContent = startNode.textContent;
        startNode.parentNode.replaceChild(span, startNode);
    }
    */
    
    //CHANGES
    function setChangeListener(div,listener) {
        //amz_clog_info("setChangeListener");
        div.addEventListener("blur",    listener);
        div.addEventListener("keyup",   listener);
        div.addEventListener("paste",   listener);
        div.addEventListener("copy",    listener);
        div.addEventListener("cut",     listener);
        div.addEventListener("delete",  listener);
        div.addEventListener("mouseup", listener);
        //div.addEventListener("touchstart", listener);
    }
    setChangeListener(editorx, function (event) {
       try{
           //if (event instanceof KeyboardEvent){ }
           me.backuprange()
           //amz_clog_info("change " + $(document).height());
           me.notify_height_changed()
       }catch(ex){
           amz_clog_err("setChangeListener " + ex)
       }
   });

    function listenOnKeyPressChange(div) {
        div.addEventListener("keypress", keypress_changed, false);
    }
    listenOnKeyPressChange(editorx)
    
    function keypress_changed(e){
        try{
            //amz_clog_info('keypressChanged ' + e);
            if(e.which != 13) {
                return
            }
            spezza_quote(e)
        }catch(ex){
            amz_clog_err('keypress_changed ' +ex);
        }
    }
    
    function spezza_quote(e){
        try{
            //log_info('You pressed enter!');
            var selection = window.getSelection();
            var range     = selection.getRangeAt(0);
            
            //log_info('startContainer ' + range.startContainer);
            //log_info('endContainer '   + range.endContainer);
            //                log_info('startContainer ' + $(range.startContainer).html());
            //                log_info('startContainer ' + $(range.startContainer).html());
            
            
            var parents     = $(range.startContainer).parents('blockquote');
            if(parents.length == 0){
                return;
            }
            
            e.preventDefault();
            
            var blockquote      = parents[parents.length-1];
            //var dupNode = node.cloneNode(deep);
            var divObj1         = blockquote.cloneNode(true);
            divObj1.innerHTML    = '';
            
            var divObj2         = blockquote.cloneNode(true);
            divObj2.innerHTML   = '';
            
            //https://developer.mozilla.org/en-US/docs/Web/API/Node/nodeType
            //https://developer.mozilla.org/en-US/docs/Web/API/Text
            
            var type        = range.startContainer.nodeType;
            //            if(type === 3){ //Text
            //                log_info('Text ' + range.startContainer);
            //                var start_node = range.startContainer;
            //                log_info('range.startOffset ' + range.startOffset);
            //                log_info('start_node.wholeText ' + start_node.wholeText);
            //                log_info('start_node.wholeText.length ' + start_node.wholeText.length);
            //                if(range.startOffset < start_node.wholeText.length){
            //                     start_node.splitText(range.startContainer.startOffset);
            //                    log_info('splitText');
            //
            //                }
            //            }
            
            {
                var upRange = document.createRange();
                upRange.setStart(blockquote, 0);
                upRange.setEnd(range.startContainer, range.startOffset); //range.startContainer.childNodes.length
                var upper_fragment = upRange.extractContents();
                divObj1.appendChild(upper_fragment);
            }
            
            {
                var downRange = document.createRange();
                downRange.setStart(range.startContainer, range.startOffset);
                downRange.setEnd(blockquote, 1);
                var lower_fragment = downRange.extractContents();
                divObj2.appendChild(lower_fragment);
                //https://developer.mozilla.org/en-US/docs/Web/API/Range/extractContents
            }
            
            //                    log_info('upper_div   ' + divObj1.innerHTML);
            //                    log_info('------');
            //                    log_info('------');
            //                    log_info('------');
            //                    log_info('lower_div   ' + divObj2.innerHTML);
            
            //replacedNode = parentNode.replaceChild(newChild, oldChild);
            blockquote.parentNode.replaceChild(divObj1,blockquote);
            divObj1.parentNode.insertBefore(divObj2,divObj1.nextSibling);
            
            var pObj1   = document.createElement('p');
            var brObj1  = document.createElement('br');
            pObj1.appendChild(brObj1);
            
            divObj1.parentNode.insertBefore(pObj1,divObj2);
            
            var selRange = document.createRange();
            selRange.setStart(pObj1, 0);
            selRange.setEnd(pObj1, 1);
            var selection = window.getSelection();
            selection.removeAllRanges();
            selection.addRange(selRange);
            
        }catch(ex){
            amz_clog_err('spezza_quote ' +ex);
        }

    }
    
    this.did_focus = function () {
        try{
            amz_clog_info("did_focus");
//            {
//                var selection = window.getSelection();
//                selection.removeAllRanges();
//                var range = document.createRange();
//                range.setStart(document.getElementById('wk_editor'), 0);
//                range.setEnd(document.getElementById('wk_editor'), 0);
//                selection.addRange(range);
//            }
            this.apply_font()
        }catch(ex){
            amz_clog_err("did_focus err "+ex);
        }
    }

    this.apply_font = function(){
        try
        {
            amz_clog_info("apply_font");
            var bag = this.inizitialize_bag
            if(!isRealValue(bag)){
                amz_clog_info("apply_font no bag");
                return
            }
            
            var selection = window.getSelection();
            selection.removeAllRanges();
            var range = document.createRange();
            range.setStart(document.getElementById('wk_editor'), 0);
            range.setEnd(document.getElementById('wk_editor'), 0);
            selection.addRange(range);

                amz_clog_info("initializex font_name "  + bag.font);
                amz_clog_info("initializex font_size "  + bag.size);
                amz_clog_info("initializex font_color " + bag.color);

            this.apply_font_internal(bag)

////            amz_clog_info("initializex font_name "  + bag.font_name);
////            amz_clog_info("initializex font_size "  + bag.font_size);
////            amz_clog_info("initializex font_color " + bag.font_color);
//            document.execCommand("styleWithCSS", null, true);
//            if(isRealValue(bag.font_name)){
//                amz_clog_info("set font_name "  + bag.font_name);
//
//                var selection = window.getSelection();
//                selection.removeAllRanges();
//                var range = document.createRange();
//                range.setStart(document.getElementById('wk_editor'), 0);
//                range.setEnd(document.getElementById('wk_editor'), 0);
//                selection.addRange(range);
//
//                document.execCommand("fontname",  false, bag.font_name);
//
//
//                //document.execCommand("forecolor", false, "rgba(1,0,0,1)");//'rgba(0,0,0,0.5)');
//            }
//            {
//
//            }
//            document.execCommand("styleWithCSS", null, false);


        }
        catch(ex){
            amz_clog_err("applyFont "+ex);
        }
    }

    this.apply_font_internal = function (commandDictionary){
        try{
            //amz_clog_info("apply_font_internal");
            var sel     = this.selection();
            var range   = sel.getRangeAt(0);
            document.execCommand("styleWithCSS", null, true);
            if(isRealValue(commandDictionary.font)){
                amz_clog_info("set font_name "  + commandDictionary.font);
                document.execCommand("fontname",  false, commandDictionary.font);
            }
            if(isRealValue(commandDictionary.size)){
                var sel     = this.selection();
                var range   = sel.getRangeAt(0);
                //                    var start   = range.startContainer
                //                    amz_clog_info("start " + start)
                //                    var jstart  = $(start)
                //                    var fs = this.get_style(jstart, "font-size")
                //                    amz_clog_info("fs " + fs.style)
                //                    if(isRealValue(fs.style) && isRealValue(fs.node)){
                //                        fs.node.css("font-size",commandDictionary.size+"px")
                //                    }else{
                var newNode = document.createElement("span");
                $(newNode).css("font-size", commandDictionary.size+"px")
                range.surroundContents(newNode);
                //                    }
                //document.execCommand("fontsize",  false, commandDictionary.size+'px');
            }
            if(isRealValue(commandDictionary.color)){
                //amz_clog_info("color " + commandDictionary.color)
                document.execCommand("forecolor", false, commandDictionary.color);//'rgba(0,0,0,0.5)');
            }
            document.execCommand("styleWithCSS", null, false);

        }
        catch(ex){
            amz_clog_err("apply_font_internal "+ex);
        }

    }
}


//            log_error("applyFontInternal");
//
//            document.execCommand("styleWithCSS", null, true);
//            try{
//                if(data_body.font  != null && data_body.font.length > 0){
//                    document.execCommand("fontname",  false, data_body.font);
//                }
//            }
//            catch(ex){
//                log_error("fontname "+ex);
//            }
//
//            try{
//                if(data_body.size  != null && data_body.size > 0){
//                    document.execCommand("fontsize",  false, data_body.size); //
//                }
//            }
//            catch(ex){
//                log_error("fontsize "+ex);
//            }
//
//            try{
//                if(data_body.color != null && data_body.color.length > 0){
//                    document.execCommand("forecolor", false, data_body.color);
//                }
//            }
//            catch(ex){
//                log_error("forecolor "+ex);
//            }
//            document.execCommand("styleWithCSS", null, false);



//UTILITIES
function composer_decode(obj_base64) {
    var sDecodedParam = b64DecodeUnicode(obj_base64);
    return JSON.parse(sDecodedParam);
}

function amz_clog_err(err) {
    window.webkit.messageHandlers.clog.postMessage({err: err});
}

function amz_clog_info(err) {
    window.webkit.messageHandlers.clog.postMessage({log: err});
}

function amz_csend_msg(xvar) {
    window.webkit.messageHandlers.cmsg.postMessage(xvar);
}

function isRealValue(obj){
    return obj && obj !== 'null' && obj !== 'undefined';
}

function b64DecodeUnicode(str) {
    return decodeURIComponent(Array.prototype.map.call(atob(str), function(c) {
                                                            return '%' + ('00' + c.charCodeAt(0).toString(16)).slice(-2);
                                                       }).join(''));
}

function b64EncodeUnicode(str) {
    return btoa(encodeURIComponent(str).replace(/%([0-9A-F]{2})/g, function(match, p1) {
                                                    return String.fromCharCode('0x' + p1);
                                                }));
}

function escapeRegExp(str) {
    return str.replace(/([.*+?^=!:${}()|\[\]\/\\])/g, "\\$1");
}

function replaceAll(str, find, replace) {
    return str.replace(new RegExp(escapeRegExp(find), 'g'), replace);
}


//amz_clog_info("start " + start)
//amz_clog_info("start " + start.nodeName)
//amz_clog_info("parent " + $(start).parent()[0].nodeName)
//amz_clog_info("font-size " + $(start).css("font-size"))
//var start_offset    = range.startOffset
//amz_clog_info("start_offset " + start_offset)

/*
 var frag = range.cloneContents()
 amz_clog_info("frag " + frag)
 amz_clog_info("frag.children " + frag.children)
 */

//amz_clog_info("sel0 " + sel.rangeCount)
//amz_clog_info("sel1 " + $(sel))
//amz_clog_info("sel2 " + sel.innerHTML) //
//amz_clog_info("sel3 " + $(sel).html()) //

//$(start).css( "background-color", "red" );
